/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc;

import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private static final String ONLY_ENCH_BOOK = "onlyEnchantedBooks";
    private static final String NEW_LINES = "addNewLines";
    private static final String SHOW_OWNER = "showOwner";
    private static final String REQUIRE_KEYBIND = "requireKeybind";
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue onlyEnchBooks;
    private final ForgeConfigSpec.BooleanValue newLines;
    private final ForgeConfigSpec.BooleanValue showOwner;
    private final ForgeConfigSpec.BooleanValue requireKeybind;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings for the mod.");
        builder.push("general");
        builder.comment("Should descriptions only be shown on enchanted books?");
        this.onlyEnchBooks = builder.define(ONLY_ENCH_BOOK, true);
        builder.comment("Should new/blank lines be added between enchantments?");
        this.newLines = builder.define(NEW_LINES, true);
        builder.comment("Should the mod that owns the enchantment be displayed?");
        this.showOwner = builder.define(SHOW_OWNER, true);
        builder.comment("Should players be required to press a keybind in order to see the descriptions?");
        this.requireKeybind = builder.define(REQUIRE_KEYBIND, true);
        builder.pop();
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean onlyShowOnEnchantedBooks() {
        return (Boolean)this.onlyEnchBooks.get();
    }

    public boolean shouldAddNewlines() {
        return (Boolean)this.newLines.get();
    }

    public boolean shouldShowOwner() {
        return (Boolean)this.showOwner.get();
    }

    public boolean requiresKeybindPress() {
        return (Boolean)this.requireKeybind.get();
    }
}

